/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	WaypointEditor
**
** DESCRIPTION:	Editor for positioning waypoints
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef WAYPOINT_EDITOR_H
#define WAYPOINT_EDITOR_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwTypes.h"
#include "ldwImage.h"
#include "EditorInterface.h"
#include "../World/Waypoint.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CWaypointEditor : public IEditor
{
private:

	//class enumerations

	//class data
	EWaypoint		m_eCurrentWaypoint;

	ldwImage *		m_pFocusCircle;

	//class methods
	//setup
	public:		CWaypointEditor(void);
	public:		void Reset();
	public:		void LoadAssets();
	public:		void ReleaseAssets();

	// process
	public:		void Draw();
	public:		void DrawWaypoints();
	public:		const bool HandleKeyCharacter(const char cKey);
	public:		const bool HandleKeyDown(const int iKeyCode);
	public:		const bool HandleKeyUp(const int iKeyCode);
	public:		const bool HandleMouseDown(const ldwPoint sMousePos);
	public:		const bool HandleMouseUp(const ldwPoint sMousePos);
	public:		const bool HandleMouseMove(const ldwPoint sMousePos);

	// access
	public:		const char *GetWaypointName(const EWaypoint eWaypoint) const;
	public:		const char *GetWaypointEnumName(const EWaypoint eWaypoint) const;
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CWaypointEditor		WaypointEditor;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/